<?php
/**
 * Post single content
 *
 * @package OceanWP WordPress theme
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<?php do_action( 'ocean_before_single_post_content' ); ?>

<div class="entry-content clr"<?php oceanwp_schema_markup( 'entry_content' ); ?>>
<div class="entry-content-left">
	<?php
	the_content();

	wp_link_pages(
		array(
			'before'      => '<div class="page-links">' . __( 'Pages:', 'oceanwp' ),
			'after'       => '</div>',
			'link_before' => '<span class="page-number">',
			'link_after'  => '</span>',
		)
	);
	?>
	
	</div>
	
<div class="price-sidebar">
<div class="tour-details price-sidebar-inner">
	    
            <h3><i class="fa fa-asterisk" aria-hidden="true"></i> Details</h3>
	
	        <?php if ( get_field('tour_duration') ) : ?>
            <p class="offer-price-per-day">Duration: <?php echo get_field('tour_duration'); ?></p>
            <?php endif; ?>
   
					<?php if ( get_field('price') ) : ?>
            <p class="price-per-week">Price: <?php echo get_field('price'); ?> <?php else : ?>Price: Negotiatable</p>
            <?php endif; ?>
	</div>
	<div class="tour-contact">
		 <h3><i class="fa fa-comments" aria-hidden="true"></i> Contact</h3>
		
		
	     <?php echo do_shortcode('[contact-form-7 id="2135" title="Contact form 7-single-tours"]');?>
			</div>
	<div class="price-sidebar-inner">
	        <blockquote>
			Please reach us on Call or Whatsapp to discuss even better deals if applicable according to the requirements.	
	</blockquote>
           
			 <div class="car-card-cta">
                    <a class="call-cta-link" href="tel:+1 714-444-3888"><p class="call-cta"><i class="fa-solid fa-phone" aria-hidden="true"></i> Call</p></a>
                    <a class="whatsapp-cta-link" href="https://wa.me/17148835383?text= Hello, I am interested in Little Saigon Tours services by your company, May I know about <?php the_title();?> ?" target="_blank" rel="noopener"><p class="whatsapp-cta"><i class="fa fa-whatsapp" aria-hidden="true"></i> WhatsApp</p></a>
                </div>

	
				</div>
			
</div>

</div><!-- .entry -->

<?php do_action( 'ocean_after_single_post_content' ); ?>




				<style>
					
				.single-rental_cars .background-image-page-header {
    height: 550px;
    background-position: bottom center;
    background-repeat: no-repeat;
    background-size: cover;
}
.overlay-bg {
    background: #00000073;
    height: 100%;
    width: 100%;
    position: absolute;
}	
					
					
	.price-sidebar-inner blockquote {
    font-style: italic;
    margin: 20px 5px;
    padding-left: 20px;
    border-left-width: 2px;
    border-style: solid;
    border-left-color: #fff;
		color:#fff;
}

.tour-details.price-sidebar-inner {
    background: #FF5722;
    margin-bottom: 0px;
    padding: 30px 20px 30px 20px;
	color:#fff;
}
					
	.tour-details h3{
		color:#fff;
					}				
					
	.tour-contact {
    background: #054B83;
    margin-bottom: 0px;
    padding: 30px 20px 30px 20px;
}
					.tour-contact h3{
						color: #fff;
					}
					.tour-contact{}
					::placeholder { /* Chrome, Firefox, Opera, Safari 10.1+ */
  color: #fff;
  opacity: 1; /* Firefox */
}

:-ms-input-placeholder { /* Internet Explorer 10-11 */
  color: #fff;
}

::-ms-input-placeholder { /* Microsoft Edge */
  color: #fff;
}
					form input[type=text], form input[type=password], form input[type=email], form input[type=url], form input[type=date], form input[type=month], form input[type=time], form input[type=datetime], form input[type=datetime-local], form input[type=week], form input[type=number], form input[type=search], form input[type=tel], form input[type=color], form select, form textarea {
    color: #fff;
}
					
.price-sidebar-inner {
    background: #892626;
    margin-bottom: 0px;
    padding: 30px 20px 30px 20px;
}
					.elementor-tabs-content-wrapper h4, .elementor-tabs-content-wrapper p{
						margin-bottom:10px;
					}
				
				.car-card-cta {
    display: flex;
    flex-flow: row;
    justify-content: space-between;
}
.car-card-cta a {
    color: #ffffff!important;
    font-size: 1.2em;
    text-decoration: none;
}
.car-card-cta a .call-cta {
    padding: 13px;
    background: #ff3837;
    width: 150px;
    text-align: center;
    color: #fff;
    border-radius: 6px;
    font-weight: 600;
    font-size: 1em;
}
.car-card-cta a .whatsapp-cta {
    padding: 13px;
    background: #25d366!important;
    width: 150px;
    text-align: center;
    color: #fff;
    border-radius: 6px;
    font-weight: 600;
    font-size: 1em;
}
.fa-tag{
	font-size:20px;
}

					
					@media only screen and (max-width:1200px){
						.car-card-cta {
    display: block;
   
}
					}
							@media only screen and (max-width:768px){
								.single-rental_cars .entry-content {
    margin-bottom: 20px;
    display: block;
}
					.entry-content-left {
    width: 100%;
    margin-right: 0px;
}
	.price-sidebar {
    width: 100%;
}	
								
	.background-image-page-header {
    height: auto !important;
    min-height: 300px;
}								
								
								
}
				
					
					
					
					
				</style>

				
